import Header from "@/components/header"
import Footer from "@/components/footer"
import { Card, CardContent } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import { Target, Eye, Heart, Users, Leaf, Truck } from "lucide-react"

export default function AboutPage() {
  const values = [
    {
      icon: Heart,
      title: "Community First",
      description: "Supporting local farmers, vendors, and families in Karur",
    },
    {
      icon: Leaf,
      title: "Fresh & Natural",
      description: "Committed to delivering the freshest, locally-sourced produce",
    },
    {
      icon: Users,
      title: "Trust & Reliability",
      description: "Building lasting relationships through consistent quality service",
    },
    {
      icon: Truck,
      title: "Innovation",
      description: "Using technology to simplify farm-to-home delivery",
    },
  ]

  const missions = [
    "Support local vendors and farmers with digital tools",
    "Deliver fresh vegetables and fruits to homes every day",
    "Build a sustainable ecosystem for customers and vendors",
    "Promote healthy eating habits in our community",
  ]

  return (
    <div className="min-h-screen bg-background">
      <Header />

      {/* Hero Section */}
      <section className="relative py-20 bg-gradient-to-br from-primary/5 via-background to-secondary/5">
        <div className="container mx-auto px-4 sm:px-6 lg:px-8">
          <div className="max-w-4xl mx-auto text-center space-y-8">
            <Badge className="bg-secondary/10 text-secondary border-secondary/20">Our Story</Badge>
            <h1 className="text-4xl md:text-5xl font-bold text-balance">About Kadai2Manai</h1>
            <p className="text-xl text-muted-foreground text-pretty">
              Bridging the gap between farmers, vendors, and customers through innovative farm-to-home delivery
              solutions in Karur, Tamil Nadu.
            </p>
          </div>
        </div>
      </section>

      {/* Story Section */}
      <section className="py-20">
        <div className="container mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-16 items-center">
            <div className="space-y-8">
              <div className="space-y-4">
                <h2 className="text-3xl md:text-4xl font-bold text-balance">Our Story</h2>
                <p className="text-lg text-muted-foreground text-pretty">
                  Founded in 2025 by <strong className="text-foreground">Mr. Manoharan</strong>, a former IT
                  professional turned passionate farmer, Kadai2Manai was built to bridge the gap between farmers,
                  vendors, and customers.
                </p>
                <p className="text-lg text-muted-foreground text-pretty">
                  Our mission is to simplify fresh produce delivery across Karur and expand across Tamil Nadu, creating
                  a sustainable ecosystem that benefits everyone in the supply chain.
                </p>
                <p className="text-lg text-muted-foreground text-pretty">
                  What started as a simple idea to help local vendors reach more customers has grown into a
                  comprehensive platform that ensures fresh, quality produce reaches every doorstep in Karur before 6:30
                  AM.
                </p>
              </div>
            </div>

            <div className="relative">
              <div className="hover-lift">
                <img
                  src="/placeholder-62p7c.png"
                  alt="Mr. Manoharan with fresh produce"
                  className="w-full h-auto rounded-2xl shadow-2xl"
                />
              </div>
              <div className="absolute -top-4 -right-4 w-32 h-32 bg-primary/20 rounded-full blur-2xl"></div>
              <div className="absolute -bottom-4 -left-4 w-32 h-32 bg-secondary/20 rounded-full blur-2xl"></div>
            </div>
          </div>
        </div>
      </section>

      {/* Vision & Mission */}
      <section className="py-20 bg-muted/30">
        <div className="container mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-12">
            {/* Vision */}
            <Card className="hover-lift bg-card/50 backdrop-blur">
              <CardContent className="p-8 space-y-6">
                <div className="flex items-center space-x-4">
                  <div className="w-16 h-16 bg-primary/10 rounded-full flex items-center justify-center">
                    <Eye className="h-8 w-8 text-primary" />
                  </div>
                  <h3 className="text-2xl font-bold">Our Vision</h3>
                </div>
                <p className="text-lg text-muted-foreground">
                  To revolutionize the fresh produce industry by making farm-to-home delivery accessible, reliable, and
                  community-driven across Tamil Nadu and beyond.
                </p>
              </CardContent>
            </Card>

            {/* Mission */}
            <Card className="hover-lift bg-card/50 backdrop-blur">
              <CardContent className="p-8 space-y-6">
                <div className="flex items-center space-x-4">
                  <div className="w-16 h-16 bg-secondary/10 rounded-full flex items-center justify-center">
                    <Target className="h-8 w-8 text-secondary" />
                  </div>
                  <h3 className="text-2xl font-bold">Our Mission</h3>
                </div>
                <ul className="space-y-3">
                  {missions.map((mission, index) => (
                    <li key={index} className="flex items-start space-x-3">
                      <div className="w-2 h-2 bg-secondary rounded-full mt-2 flex-shrink-0"></div>
                      <span className="text-muted-foreground">{mission}</span>
                    </li>
                  ))}
                </ul>
              </CardContent>
            </Card>
          </div>
        </div>
      </section>

      {/* Values Section */}
      <section className="py-20">
        <div className="container mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center space-y-4 mb-16">
            <h2 className="text-3xl md:text-4xl font-bold text-balance">Our Values</h2>
            <p className="text-xl text-muted-foreground max-w-2xl mx-auto text-pretty">
              The principles that guide everything we do at Kadai2Manai
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            {values.map((value, index) => (
              <Card key={index} className="hover-lift text-center">
                <CardContent className="p-8 space-y-4">
                  <div className="w-16 h-16 bg-primary/10 rounded-full flex items-center justify-center mx-auto">
                    <value.icon className="h-8 w-8 text-primary" />
                  </div>
                  <h3 className="text-xl font-semibold">{value.title}</h3>
                  <p className="text-muted-foreground">{value.description}</p>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Team Section */}
      <section className="py-20 bg-gradient-to-br from-primary/5 to-secondary/5">
        <div className="container mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center space-y-4 mb-16">
            <h2 className="text-3xl md:text-4xl font-bold text-balance">Meet Our Founder</h2>
            <p className="text-xl text-muted-foreground max-w-2xl mx-auto text-pretty">
              The visionary behind Kadai2Manai's mission to transform fresh produce delivery
            </p>
          </div>

          <div className="max-w-4xl mx-auto">
            <Card className="hover-lift bg-card/50 backdrop-blur">
              <CardContent className="p-8 md:p-12">
                <div className="grid grid-cols-1 md:grid-cols-3 gap-8 items-center">
                  <div className="md:col-span-1">
                    <img
                      src="/placeholder-kv3pm.png"
                      alt="Mr. Manoharan - Founder"
                      className="w-full h-auto rounded-2xl shadow-lg"
                    />
                  </div>
                  <div className="md:col-span-2 space-y-4">
                    <div>
                      <h3 className="text-2xl font-bold">Mr. Manoharan</h3>
                      <p className="text-lg text-primary">Founder & CEO</p>
                    </div>
                    <p className="text-muted-foreground">
                      A former IT professional who discovered his passion for farming and community service. Mr.
                      Manoharan combines his technical expertise with deep agricultural knowledge to create innovative
                      solutions that benefit farmers, vendors, and customers alike.
                    </p>
                    <p className="text-muted-foreground">
                      His vision of connecting local communities through fresh produce delivery has made Kadai2Manai a
                      trusted name in Karur, with plans to expand across Tamil Nadu.
                    </p>
                  </div>
                </div>
              </CardContent>
            </Card>
          </div>
        </div>
      </section>

      <Footer />
    </div>
  )
}
