import type React from "react"
import type { Metadata } from "next"
import { GeistSans } from "geist/font/sans"
import { GeistMono } from "geist/font/mono"
import { Analytics } from "@vercel/analytics/next"
import { Suspense } from "react"
import "./globals.css"

export const metadata: Metadata = {
  title: "Kadai2Manai - Fresh Vegetable & Fruit Delivery in Karur",
  description:
    "Farm-to-home delivery of fresh vegetables and fruits in Karur, Tamil Nadu. Early morning delivery before 6:30 AM with cash on delivery.",
  keywords:
    "fresh vegetables, fruit delivery, Karur, Tamil Nadu, farm to home, cash on delivery, early morning delivery, local vendors",
  generator: "Kadai2Manai",
}

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode
}>) {
  return (
    <html lang="en">
      <body className={`font-sans ${GeistSans.variable} ${GeistMono.variable}`}>
        <Suspense fallback={null}>{children}</Suspense>
        <Analytics />
      </body>
    </html>
  )
}
