import Header from "@/components/header"
import Footer from "@/components/footer"
import { Button } from "@/components/ui/button"
import { Card, CardContent } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import { Clock, Truck, CreditCard, Users, CheckCircle, Star } from "lucide-react"
import Link from "next/link"

export default function HomePage() {
  const features = [
    {
      icon: Clock,
      title: "Early Morning Delivery",
      description: "Fresh produce delivered before 6:30 AM every day",
    },
    {
      icon: CreditCard,
      title: "100% Cash on Delivery",
      description: "No online payment needed - pay when you receive",
    },
    {
      icon: Truck,
      title: "Local Vendor Network",
      description: "Supporting trusted neighborhood vendors",
    },
    {
      icon: Users,
      title: "Community Focused",
      description: "Connecting farmers, vendors, and customers",
    },
  ]

  const benefits = [
    "Early morning delivery before 6:30 AM",
    "100% cash on delivery – no online payment needed",
    "Locally sourced vegetables and fruits from trusted vendors",
    "Easy customer registration – no sign-up hassle",
    "Supports farmers, vendors, and the local community",
  ]

  return (
    <div className="min-h-screen bg-background">
      <Header />

      {/* Hero Section */}
      <section className="relative overflow-hidden bg-gradient-to-br from-primary/5 via-background to-secondary/5">
        <div className="container mx-auto px-4 sm:px-6 lg:px-8 py-20">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <div className="space-y-8 animate-fade-in-up">
              <div className="space-y-4">
                <Badge className="bg-secondary/10 text-secondary border-secondary/20">Farm-to-Home Delivery</Badge>
                <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold text-balance">
                  Fresh Vegetable & Fruit Delivery in <span className="text-primary">Karur</span>
                </h1>
                <p className="text-xl text-muted-foreground text-pretty">
                  Farm-to-Home Delivery, Simplified for You. Get fresh vegetables and fruits delivered directly to your
                  doorstep every morning before 6:30 AM.
                </p>
              </div>

              <div className="flex flex-col sm:flex-row gap-4">
                <Button size="lg" className="bg-primary hover:bg-primary/90 text-primary-foreground">
                  Order Now
                </Button>
                <Button size="lg" variant="outline" asChild>
                  <Link href="/about">Learn More</Link>
                </Button>
              </div>

              <div className="flex items-center space-x-6 text-sm text-muted-foreground">
                <div className="flex items-center space-x-2">
                  <Star className="h-5 w-5 text-yellow-500 fill-current" />
                  <span>Trusted by 1000+ families</span>
                </div>
                <div className="flex items-center space-x-2">
                  <CheckCircle className="h-5 w-5 text-secondary" />
                  <span>100% Fresh Guarantee</span>
                </div>
              </div>
            </div>

            <div className="relative">
              <div className="relative z-10 hover-lift">
                <img
                  src="/placeholder-d97ma.png"
                  alt="Fresh vegetables and fruits basket"
                  className="w-full h-auto rounded-2xl shadow-2xl"
                />
              </div>
              <div className="absolute -top-4 -right-4 w-72 h-72 bg-secondary/20 rounded-full blur-3xl animate-bounce-gentle"></div>
              <div
                className="absolute -bottom-4 -left-4 w-72 h-72 bg-primary/20 rounded-full blur-3xl animate-bounce-gentle"
                style={{ animationDelay: "1s" }}
              ></div>
            </div>
          </div>
        </div>
      </section>

      {/* How It Works Section */}
      <section className="py-20 bg-muted/30">
        <div className="container mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center space-y-4 mb-16">
            <h2 className="text-3xl md:text-4xl font-bold text-balance">How Kadai2Manai Works</h2>
            <p className="text-xl text-muted-foreground max-w-2xl mx-auto text-pretty">
              Simple, reliable, and community-driven fresh produce delivery
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
            <Card className="hover-lift bg-card/50 backdrop-blur">
              <CardContent className="p-8 text-center space-y-4">
                <div className="w-16 h-16 bg-primary/10 rounded-full flex items-center justify-center mx-auto">
                  <Users className="h-8 w-8 text-primary" />
                </div>
                <h3 className="text-xl font-semibold">Customers</h3>
                <p className="text-muted-foreground">
                  Order vegetables and fruits at night, receive them fresh in the morning before 6:30 AM
                </p>
              </CardContent>
            </Card>

            <Card className="hover-lift bg-card/50 backdrop-blur">
              <CardContent className="p-8 text-center space-y-4">
                <div className="w-16 h-16 bg-secondary/10 rounded-full flex items-center justify-center mx-auto">
                  <Truck className="h-8 w-8 text-secondary" />
                </div>
                <h3 className="text-xl font-semibold">Vendors</h3>
                <p className="text-muted-foreground">
                  Register customers at their doorstep, manage orders via app, and deliver with live GPS tracking
                </p>
              </CardContent>
            </Card>

            <Card className="hover-lift bg-card/50 backdrop-blur">
              <CardContent className="p-8 text-center space-y-4">
                <div className="w-16 h-16 bg-primary/10 rounded-full flex items-center justify-center mx-auto">
                  <CheckCircle className="h-8 w-8 text-primary" />
                </div>
                <h3 className="text-xl font-semibold">Admin</h3>
                <p className="text-muted-foreground">
                  Oversees orders, vendor performance, and delivery flow from warehouse to customer
                </p>
              </CardContent>
            </Card>
          </div>
        </div>
      </section>

      {/* Features Section */}
      <section className="py-20">
        <div className="container mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-16 items-center">
            <div className="space-y-8">
              <div className="space-y-4">
                <h2 className="text-3xl md:text-4xl font-bold text-balance">Why Choose Kadai2Manai in Karur?</h2>
                <p className="text-xl text-muted-foreground text-pretty">
                  We're committed to delivering the freshest produce while supporting our local community
                </p>
              </div>

              <div className="space-y-4">
                {benefits.map((benefit, index) => (
                  <div key={index} className="flex items-start space-x-3">
                    <CheckCircle className="h-6 w-6 text-secondary mt-0.5 flex-shrink-0" />
                    <span className="text-foreground">{benefit}</span>
                  </div>
                ))}
              </div>

              <Button size="lg" className="bg-secondary hover:bg-secondary/90 text-secondary-foreground" asChild>
                <Link href="/services">Explore Our Services</Link>
              </Button>
            </div>

            <div className="grid grid-cols-2 gap-6">
              {features.map((feature, index) => (
                <Card key={index} className="hover-lift">
                  <CardContent className="p-6 space-y-4">
                    <div className="w-12 h-12 bg-primary/10 rounded-lg flex items-center justify-center">
                      <feature.icon className="h-6 w-6 text-primary" />
                    </div>
                    <div className="space-y-2">
                      <h3 className="font-semibold">{feature.title}</h3>
                      <p className="text-sm text-muted-foreground">{feature.description}</p>
                    </div>
                  </CardContent>
                </Card>
              ))}
            </div>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-20 bg-gradient-to-r from-primary to-secondary">
        <div className="container mx-auto px-4 sm:px-6 lg:px-8 text-center">
          <div className="max-w-3xl mx-auto space-y-8">
            <h2 className="text-3xl md:text-4xl font-bold text-primary-foreground text-balance">
              Ready to Get Fresh Produce Delivered?
            </h2>
            <p className="text-xl text-primary-foreground/90 text-pretty">
              Join thousands of satisfied customers in Karur who trust Kadai2Manai for their daily fresh produce needs
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Button size="lg" variant="secondary" className="bg-background text-foreground hover:bg-background/90">
                Download App
              </Button>
              <Button
                size="lg"
                variant="outline"
                className="border-primary-foreground text-primary-foreground hover:bg-primary-foreground hover:text-primary bg-transparent"
                asChild
              >
                <Link href="/contact">Contact Us</Link>
              </Button>
            </div>
          </div>
        </div>
      </section>

      <Footer />
    </div>
  )
}
