import Header from "@/components/header"
import Footer from "@/components/footer"
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import { Button } from "@/components/ui/button"
import { Smartphone, Users, Truck, Clock, CreditCard, MapPin, CheckCircle, Star } from "lucide-react"
import Link from "next/link"

export default function ServicesPage() {
  const customerFeatures = [
    "Order vegetables & fruits in just a few taps",
    "Track your orders in real-time",
    "Get early morning delivery before 6:30 AM",
    "Pay only on delivery (COD)",
    "Browse seasonal and fresh produce",
    "Easy reorder of favorite items",
  ]

  const vendorFeatures = [
    "Register new customers at their doorstep",
    "Generate login credentials for customers",
    "Receive and manage orders from the admin panel",
    "Deliver using live GPS navigation",
    "Mark orders complete only after collecting COD",
    "Track earnings and performance metrics",
  ]

  const customerBenefits = [
    "Fresh and local vegetables every day",
    "No need to visit crowded markets",
    "Hassle-free COD payment",
    "Reliable delivery by trusted neighborhood vendors",
    "Quality guarantee on all products",
    "Support local community and farmers",
  ]

  return (
    <div className="min-h-screen bg-background">
      <Header />

      {/* Hero Section */}
      <section className="relative py-20 bg-gradient-to-br from-primary/5 via-background to-secondary/5">
        <div className="container mx-auto px-4 sm:px-6 lg:px-8">
          <div className="max-w-4xl mx-auto text-center space-y-8">
            <Badge className="bg-secondary/10 text-secondary border-secondary/20">Our Services</Badge>
            <h1 className="text-4xl md:text-5xl font-bold text-balance">Our Services – Kadai2Manai</h1>
            <p className="text-xl text-muted-foreground text-pretty">
              Comprehensive solutions for customers and vendors to ensure fresh produce reaches every home in Karur
              efficiently and reliably.
            </p>
          </div>
        </div>
      </section>

      {/* Customer Application */}
      <section className="py-20">
        <div className="container mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-16 items-center">
            <div className="space-y-8">
              <div className="space-y-4">
                <div className="flex items-center space-x-3">
                  <div className="w-12 h-12 bg-primary/10 rounded-lg flex items-center justify-center">
                    <Smartphone className="h-6 w-6 text-primary" />
                  </div>
                  <h2 className="text-3xl md:text-4xl font-bold">Customer Application</h2>
                </div>
                <p className="text-xl text-muted-foreground text-pretty">
                  Our customer app is designed for simplicity and trust, making it easy for anyone to order fresh
                  produce.
                </p>
              </div>

              <div className="space-y-4">
                {customerFeatures.map((feature, index) => (
                  <div key={index} className="flex items-start space-x-3">
                    <CheckCircle className="h-6 w-6 text-secondary mt-0.5 flex-shrink-0" />
                    <span className="text-foreground">{feature}</span>
                  </div>
                ))}
              </div>

              <Button size="lg" className="bg-primary hover:bg-primary/90 text-primary-foreground">
                Download Customer App
              </Button>
            </div>

            <div className="relative">
              <div className="hover-lift">
                <img
                  src="/placeholder-ensmj.png"
                  alt="Customer App Interface"
                  className="w-full h-auto rounded-2xl shadow-2xl"
                />
              </div>
              <div className="absolute -top-4 -right-4 w-32 h-32 bg-primary/20 rounded-full blur-2xl"></div>
            </div>
          </div>
        </div>
      </section>

      {/* Vendor Application */}
      <section className="py-20 bg-muted/30">
        <div className="container mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-16 items-center">
            <div className="relative order-2 lg:order-1">
              <div className="hover-lift">
                <img
                  src="/placeholder-huvss.png"
                  alt="Vendor App Interface"
                  className="w-full h-auto rounded-2xl shadow-2xl"
                />
              </div>
              <div className="absolute -top-4 -left-4 w-32 h-32 bg-secondary/20 rounded-full blur-2xl"></div>
            </div>

            <div className="space-y-8 order-1 lg:order-2">
              <div className="space-y-4">
                <div className="flex items-center space-x-3">
                  <div className="w-12 h-12 bg-secondary/10 rounded-lg flex items-center justify-center">
                    <Users className="h-6 w-6 text-secondary" />
                  </div>
                  <h2 className="text-3xl md:text-4xl font-bold">Vendor Application</h2>
                </div>
                <p className="text-xl text-muted-foreground text-pretty">
                  Vendors are the backbone of Kadai2Manai. With the vendor app, they can efficiently manage customers
                  and deliveries.
                </p>
              </div>

              <div className="space-y-4">
                {vendorFeatures.map((feature, index) => (
                  <div key={index} className="flex items-start space-x-3">
                    <CheckCircle className="h-6 w-6 text-secondary mt-0.5 flex-shrink-0" />
                    <span className="text-foreground">{feature}</span>
                  </div>
                ))}
              </div>

              <Button size="lg" className="bg-secondary hover:bg-secondary/90 text-secondary-foreground">
                Join as Vendor
              </Button>
            </div>
          </div>
        </div>
      </section>

      {/* Service Features */}
      <section className="py-20">
        <div className="container mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center space-y-4 mb-16">
            <h2 className="text-3xl md:text-4xl font-bold text-balance">Why Our Service Stands Out</h2>
            <p className="text-xl text-muted-foreground max-w-2xl mx-auto text-pretty">
              Features that make Kadai2Manai the preferred choice for fresh produce delivery
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <Card className="hover-lift">
              <CardHeader>
                <div className="w-12 h-12 bg-primary/10 rounded-lg flex items-center justify-center mb-4">
                  <Clock className="h-6 w-6 text-primary" />
                </div>
                <CardTitle>Early Morning Delivery</CardTitle>
              </CardHeader>
              <CardContent>
                <p className="text-muted-foreground">
                  Fresh produce delivered to your doorstep before 6:30 AM, ensuring you start your day with the freshest
                  ingredients.
                </p>
              </CardContent>
            </Card>

            <Card className="hover-lift">
              <CardHeader>
                <div className="w-12 h-12 bg-secondary/10 rounded-lg flex items-center justify-center mb-4">
                  <CreditCard className="h-6 w-6 text-secondary" />
                </div>
                <CardTitle>Cash on Delivery</CardTitle>
              </CardHeader>
              <CardContent>
                <p className="text-muted-foreground">
                  No need for online payments or digital wallets. Pay only when you receive your fresh produce at your
                  doorstep.
                </p>
              </CardContent>
            </Card>

            <Card className="hover-lift">
              <CardHeader>
                <div className="w-12 h-12 bg-primary/10 rounded-lg flex items-center justify-center mb-4">
                  <MapPin className="h-6 w-6 text-primary" />
                </div>
                <CardTitle>Live GPS Tracking</CardTitle>
              </CardHeader>
              <CardContent>
                <p className="text-muted-foreground">
                  Track your delivery in real-time with live GPS updates. Know exactly when your fresh produce will
                  arrive.
                </p>
              </CardContent>
            </Card>

            <Card className="hover-lift">
              <CardHeader>
                <div className="w-12 h-12 bg-secondary/10 rounded-lg flex items-center justify-center mb-4">
                  <Truck className="h-6 w-6 text-secondary" />
                </div>
                <CardTitle>Local Vendor Network</CardTitle>
              </CardHeader>
              <CardContent>
                <p className="text-muted-foreground">
                  Supporting trusted neighborhood vendors who know the community and ensure quality produce selection.
                </p>
              </CardContent>
            </Card>

            <Card className="hover-lift">
              <CardHeader>
                <div className="w-12 h-12 bg-primary/10 rounded-lg flex items-center justify-center mb-4">
                  <Star className="h-6 w-6 text-primary" />
                </div>
                <CardTitle>Quality Guarantee</CardTitle>
              </CardHeader>
              <CardContent>
                <p className="text-muted-foreground">
                  100% satisfaction guarantee on all produce. If you're not happy with the quality, we'll make it right.
                </p>
              </CardContent>
            </Card>

            <Card className="hover-lift">
              <CardHeader>
                <div className="w-12 h-12 bg-secondary/10 rounded-lg flex items-center justify-center mb-4">
                  <Users className="h-6 w-6 text-secondary" />
                </div>
                <CardTitle>Community Support</CardTitle>
              </CardHeader>
              <CardContent>
                <p className="text-muted-foreground">
                  Every order supports local farmers and vendors, contributing to the growth of our community ecosystem.
                </p>
              </CardContent>
            </Card>
          </div>
        </div>
      </section>

      {/* Benefits for Customers */}
      <section className="py-20 bg-gradient-to-br from-primary/5 to-secondary/5">
        <div className="container mx-auto px-4 sm:px-6 lg:px-8">
          <div className="max-w-4xl mx-auto">
            <div className="text-center space-y-4 mb-16">
              <h2 className="text-3xl md:text-4xl font-bold text-balance">Benefits for Customers</h2>
              <p className="text-xl text-muted-foreground text-pretty">
                Experience the convenience and quality that thousands of families in Karur trust
              </p>
            </div>

            <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
              {customerBenefits.map((benefit, index) => (
                <div
                  key={index}
                  className="flex items-start space-x-4 p-6 bg-card/50 backdrop-blur rounded-lg hover-lift"
                >
                  <div className="w-8 h-8 bg-secondary/10 rounded-full flex items-center justify-center flex-shrink-0 mt-1">
                    <CheckCircle className="h-5 w-5 text-secondary" />
                  </div>
                  <div>
                    <p className="text-foreground font-medium">{benefit}</p>
                  </div>
                </div>
              ))}
            </div>

            <div className="text-center mt-12">
              <Button size="lg" className="bg-primary hover:bg-primary/90 text-primary-foreground" asChild>
                <Link href="/contact">Get Started Today</Link>
              </Button>
            </div>
          </div>
        </div>
      </section>

      <Footer />
    </div>
  )
}
